using System;
using Borland.Eco.Handles;
using Borland.Eco.Web;

namespace [!Namespace]
{

	public abstract class EcoSpaceProvider
	{

		// ToDo: Configure the strategy for the provider by changing the constant

		private const EcoSpaceStrategyHandler.SessionStateMode m_SessionStateMode = EcoSpaceStrategyHandler.SessionStateMode.IfDirty;

		private static EcoSpaceStrategyHandler GetStrategyhandler()
		{
			return new EcoSpaceStrategyHandler(m_SessionStateMode, typeof([!EcoSpaceClassName]));
		}

		public static [!EcoSpaceClassName] GetEcoSpace()
		{
			return GetStrategyhandler().GetEcoSpace() as [!EcoSpaceClassName];
		}

		public static void ReturnEcoSpace(EcoSpace ecoSpace)
		{
			GetStrategyhandler().ReturnEcoSpace(ecoSpace);
		}

		public static [!EcoSpaceClassName] GetSessionFreeEcoSpace()
		{
			return GetStrategyhandler().GetSessionFreeEcoSpace() as [!EcoSpaceClassName];
		}

		public static void ReturnSessionFreeEcoSpace(EcoSpace ecoSpace)
		{
			GetStrategyhandler().ReturnSessionFreeEcoSpace(ecoSpace);
		}

		public void ClearSessionState()
		{
            GetStrategyhandler().ClearSessionState();
		}
	}
}
